/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.block;

import com.refinedmods.refinedpipes.block.PipeBlock;
import com.refinedmods.refinedpipes.blockentity.ItemPipeBlockEntity;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipeType;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.Nullable;

public class ItemPipeBlock
extends PipeBlock
implements EntityBlock {
    private final ItemPipeType type;

    public ItemPipeBlock(PipeShapeCache shapeCache, ItemPipeType type) {
        super(shapeCache);
        this.type = type;
        this.setRegistryName(type.getId());
    }

    public ItemPipeType getType() {
        return this.type;
    }

    @Override
    protected boolean hasConnection(LevelAccessor world, BlockPos pos, Direction direction) {
        BlockEntity currentBlockEntity = world.m_7702_(pos);
        if (currentBlockEntity instanceof ItemPipeBlockEntity && ((ItemPipeBlockEntity)currentBlockEntity).getAttachmentManager().hasAttachment(direction)) {
            return false;
        }
        BlockState facingState = world.m_8055_(pos.m_142300_(direction));
        BlockEntity facingBlockEntity = world.m_7702_(pos.m_142300_(direction));
        if (facingBlockEntity instanceof ItemPipeBlockEntity && ((ItemPipeBlockEntity)facingBlockEntity).getAttachmentManager().hasAttachment(direction.m_122424_())) {
            return false;
        }
        return facingState.m_60734_() instanceof ItemPipeBlock;
    }

    @Override
    protected boolean hasInvConnection(LevelAccessor world, BlockPos pos, Direction direction) {
        BlockEntity facingBlockEntity = world.m_7702_(pos.m_142300_(direction));
        return facingBlockEntity != null && facingBlockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).isPresent();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ItemPipeBlockEntity(pos, state, this.type);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? (levelTicker, pos, stateTicker, blockEntity) -> ItemPipeBlockEntity.tick((ItemPipeBlockEntity)blockEntity) : null;
    }
}

